/****** Object:  StoredProcedure [dbo].[P_ATUALIZA_PRECO_TABLOIDE]    Script Date: 02/26/2014 19:52:06 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_PRECO_TABLOIDE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ATUALIZA_PRECO_TABLOIDE]
GO
GO 

--Procedure para atualizao de preos do tabloide
CREATE  PROCEDURE [dbo].[P_ATUALIZA_PRECO_TABLOIDE] @CD_EMP INT=1, @CD_TABLOIDE INT=0, @CD_USU INT=1  WITH ENCRYPTION AS  

SET NOCOUNT ON;  
DECLARE @CodigoTabloide  INT, 
	@AtivaDesativa Tinyint;

Print 'Atualizando os preos de oferta - Time '+ convert(varchar,getdate(),108)
--Ativar e desativar tabloide
EXEC P_EST_PROD_TABLOIDE_AGENDAMENTO_EXECUTE

Declare cTabloide cursor fast_forward read_only
for	
	SELECT 
		CD_TABLOIDE,
		1 ATIVA_DESATIVA
	FROM
		EST_PROD_TABLOIDE
	WHERE      
		CONVERT(DATE,GETDATE()) between EST_PROD_TABLOIDE.DT_INICIO  and EST_PROD_TABLOIDE.DT_FIM
		AND EST_PROD_TABLOIDE.CD_EMP=@CD_EMP
		AND EST_PROD_TABLOIDE.FLAG_VIGENCIA in(1,0)
		AND EST_PROD_TABLOIDE.CD_TABLOIDE =  CASE WHEN @CD_TABLOIDE  >0 THEN 
				@CD_TABLOIDE  ELSE EST_PROD_TABLOIDE.CD_TABLOIDE END
	UNION ALL
	SELECT 
		CD_TABLOIDE,
		0 ATIVA_DESATIVA
	FROM
		EST_PROD_TABLOIDE
	WHERE      
		EST_PROD_TABLOIDE.DT_FIM < CONVERT(DATE,GETDATE())
		AND EST_PROD_TABLOIDE.FLAG_VIGENCIA in(1,0)
		AND EST_PROD_TABLOIDE.CD_EMP=@CD_EMP
		AND EST_PROD_TABLOIDE.CD_TABLOIDE =  CASE WHEN @CD_TABLOIDE  >0 THEN @CD_TABLOIDE  
													ELSE EST_PROD_TABLOIDE.CD_TABLOIDE END
	ORDER BY ATIVA_DESATIVA,CD_TABLOIDE;


OPEN cTabloide 
FETCH NEXT from cTabloide  INTO @CodigoTabloide,@AtivaDesativa 
	WHILE @@FETCH_STATUS=0
	  begin
		Print 'Analisando tabloide ' + convert(varchar(10), @CodigoTabloide) + ' Time '  + convert(varchar,getdate(),108);

		EXEC P_ATUALIZA_PRECO_TABLOIDE_TABLOIDE @CD_EMP, @CodigoTabloide,@AtivaDesativa,@CD_USU;
		
		FETCH NEXT from cTabloide  INTO @CodigoTabloide,@AtivaDesativa ;
	end

	Close cTabloide  
	Deallocate cTabloide ;

	Print 'Inicio atualizacao a melhor oferta dos tabloides - Time '  + convert(varchar,getdate(),108);
	EXEC P_ATUALIZA_PRECO_TABLOIDE_MELHOR_OFERTA @cd_emp
